/*- ServoAttachListener - 
 * Populate the available fields and controls
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.ServoPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.AttachListener;
import com.phidgets.event.AttachEvent;

import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JComboBox;
import javax.swing.JSlider;

public class ServoAttachListener implements AttachListener{
    
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numServoTxt;
    private JComboBox servoCmb;
    private JTextField positionTxt;
    private JSlider positionScrl;
    private JCheckBox engagedChk;
    
    /** Creates a new instance of ServoAttachListener */
    public ServoAttachListener(JFrame appFrame, JTextField attachedTxt, 
            JTextArea nameTxt, JTextField serialTxt, JTextField versionTxt, 
            JTextField numServoTxt, JComboBox servoCmb, JTextField positionTxt,
            JSlider positionScrl, JCheckBox engagedChk)
    {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numServoTxt = numServoTxt;
        this.servoCmb = servoCmb;
        this.positionTxt = positionTxt;
        this.positionScrl = positionScrl;
        this.engagedChk = engagedChk;
    }

    public void attached(AttachEvent ae)
    {
        try
        {
            ServoPhidget attached = (ServoPhidget)ae.getSource();
            attachedTxt.setText(Boolean.toString(attached.isAttached()));
            nameTxt.setText(attached.getDeviceName());
            serialTxt.setText(Integer.toString(attached.getSerialNumber()));
            versionTxt.setText(Integer.toString(attached.getDeviceVersion()));
            numServoTxt.setText(Integer.toString(attached.getMotorCount()));
            
            //the maximum bound of the phidget servo is 232, it's minimum bound is -23
            positionScrl.setMaximum((int)attached.getPositionMax(0));
            positionScrl.setMinimum((int)attached.getPositionMin(0));
        
            servoCmb.setEnabled(true);
            
            for(int i = 0; i < attached.getMotorCount(); i++)
            {
                servoCmb.addItem(new Integer(i));
            }
            
            servoCmb.setSelectedIndex(0);
            
            try
            {
                positionTxt.setText(Double.toString(attached.getPosition(0)));
                positionScrl.setValue((int)attached.getPosition(0));
                engagedChk.setSelected(attached.getMotorOn(0));
            }
            catch(PhidgetException ex2)
            {
                positionTxt.setText("Unknown");
                positionScrl.setValue(0);
                engagedChk.setSelected(false);
            }
            
            engagedChk.setEnabled(true);
            positionScrl.setEnabled(true);
        }
        catch (PhidgetException ex)
        {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
    
}
